<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />
    
    <xsl:template match="/">
        <!-- Always set a root element -->
        <example-variables>
            <!--
                xsl:variable allows to define a variable
                @name is the variable's name
                @select must be a valid XPath or string encapsulated in simple quote, for example: 'Hello world'
                The value stored in the variable depends on the XPath, in this example it's a string.
                A variable can only be set once. YOU CANNOT UPDATE A VARIABLE.
            -->
            <xsl:variable name="tableKey" select="/Table/@key" />
            <table-key>
                <!--
                    To display a string value, you can use the xsl:value-of function
                    The content of the variable is referecend with $variableName
                -->
                <xsl:value-of select="$tableKey"/>
            </table-key>

            <xsl:variable name="simpleText" select="'Hello world'" />
            <simple-text>
                <xsl:value-of select="$simpleText"/>
            </simple-text>

            
            <!-- In the next example it's a node list of Item element -->
            <xsl:variable name="items" select="/Table/Items/Item" />
            <items>
                <!-- If you want to copy the nodes you must use the xsl:copy-of function -->
                <xsl:copy-of select="$items"/>
                <!-- Note: if you use the xsl:value-of on a node list, the value of will extrat all strings and concat them in one string -->
            </items>


            <!--
                A variable can also be defined this way, there is no select, the select is the content of the variable.
                This example is equivalent to the first example
            -->
            <xsl:variable name="tableKey2">
                <xsl:value-of select="/Table/@key"/>
            </xsl:variable>
            <table-key-2>                
                <xsl:value-of select="$tableKey2"/>
            </table-key-2>
            
            <!-- This type of variable is usefull when you have to transform the data -->
            <xsl:variable name="eans">
                <!-- The explanations of this example is done in the Loops tutorial -->
                <xsl:for-each select="/Table/Items/Item">
                    <ean>
                        <xsl:value-of select="Identifier[@key='ean']"/>
                    </ean>
                </xsl:for-each>
            </xsl:variable>
            <eans>
                <xsl:copy-of select="$eans"/>
            </eans>
        </example-variables>
    </xsl:template>
</xsl:stylesheet>